from django.contrib import admin
from .models import User
from riders.models import Rider


class RiderInline(admin.StackedInline):
	model = Rider
	can_delete = False
	fk_name = 'user'


@admin.register(User)
class UserAdmin(admin.ModelAdmin):
	inlines = (RiderInline,)
	list_display = ('id', 'username', 'email', 'first_name', 'last_name')
	search_fields = ('username', 'email', 'first_name', 'last_name')
