
from django.db import models

class Service(models.Model):
	STATUS_CHOICES = [
		('active', 'Active'),
		('inactive', 'Inactive'),
	]
	service_name = models.CharField(max_length=255)
	image = models.ImageField(upload_to='services/', null=True, blank=True)
	description = models.TextField()

	status = models.CharField(max_length=10, choices=STATUS_CHOICES, default='active')
	conditions = models.JSONField(default=list, blank=True, help_text='List of key-value pairs for conditions')
	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)

	def __str__(self):
		return self.service_name

# Create your models here.
