from django import forms
from .models import Rider


class RiderForm(forms.ModelForm):
    class Meta:
        model = Rider
        fields = [
            'full_name', 'display_name', 'dob', 'mobile_number', 'email',
            'profile_pic', 'aadhar_front', 'aadhar_back', 'pan_card_image',
            'driving_license_front', 'driving_license_back', 'status', 'trash'
        ]

    def clean_mobile_number(self):
        mobile = self.cleaned_data.get('mobile_number', '')
        # Basic normalization/validation; adjust per locale
        mobile = mobile.strip()
        if not mobile:
            raise forms.ValidationError('Mobile number is required')
        return mobile
