-- Insert categories
INSERT INTO category_category (name, parent_id, image, description, status, trash, created_at, deleted_at)
VALUES 
  ('Mens', NULL, NULL, 'Mens garments', 'active', 0, CURRENT_TIMESTAMP, NULL),
  ('Womens', NULL, NULL, 'Womens garments', 'active', 0, CURRENT_TIMESTAMP, NULL),
  ('Kids', NULL, NULL, 'Kids garments', 'active', 0, CURRENT_TIMESTAMP, NULL),
  ('Household', NULL, NULL, 'Household items', 'active', 0, CURRENT_TIMESTAMP, NULL);

-- Insert services
INSERT INTO services_service (service_name, image, description, status, conditions, created_at, updated_at)
VALUES
  ('Dry Cleaning', NULL, 'Professional dry cleaning', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP),
  ('Laundry Services', NULL, 'Laundry and washing services', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP),
  ('Household Hygiene', NULL, 'Household hygiene and sanitization', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP),
  ('Shoe Cleaning & Restoration', NULL, 'Shoe cleaning and restoration', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP),
  ('Bag Cleaning & Restoration', NULL, 'Bag cleaning and restoration', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP),
  ('Carpet Cleaning', NULL, 'Carpet cleaning service', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP),
  ('Leather Cleaning', NULL, 'Leather item cleaning', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP),
  ('Curtain Cleaning', NULL, 'Curtain cleaning service', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP),
  ('Electrical Appliances', NULL, 'Electrical appliance cleaning/servicing', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP),
  ('Mattress Cleaning', NULL, 'Mattress deep cleaning', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP),
  ('Sofa & Upholstery Cleaning', NULL, 'Sofa and upholstery cleaning', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP),
  ('Steam Iron', NULL, 'Steam ironing service', 'active', '[]', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

-- Insert garments for Mens
INSERT INTO garments_garment (name, category_id, status, description, trash, service_prices, created_at, deleted_at)
VALUES 
  ('BOXER', 1, 'active', 'BOXER', 0, '[{"service_id": 1, "price": 50.0}, {"service_id": 2, "price": 30.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('CAPRI', 1, 'active', 'CAPRI', 0, '[{"service_id": 1, "price": 60.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT COTTON', 1, 'active', 'COAT COTTON', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT FANCY', 1, 'active', 'COAT FANCY', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 90.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT VEST', 1, 'active', 'COAT VEST', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT WOOLEN', 1, 'active', 'COAT WOOLEN', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 3, "price": 90.0}]', CURRENT_TIMESTAMP, NULL),
  ('DHOTI COTTON REGULAR', 1, 'active', 'DHOTI COTTON REGULAR', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('GAMCHHA', 1, 'active', 'GAMCHHA', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET COTTON FULL', 1, 'active', 'JACKET COTTON FULL', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 250.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET COTTON HALF', 1, 'active', 'JACKET COTTON HALF', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET FANCY', 1, 'active', 'JACKET FANCY', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 90.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET HALF', 1, 'active', 'JACKET HALF', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 250.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET LEATHER', 1, 'active', 'JACKET LEATHER', 0, '[{"service_id": 1, "price": 350.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET LONG', 1, 'active', 'JACKET LONG', 0, '[{"service_id": 1, "price": 450.0}, {"service_id": 2, "price": 350.0}, {"service_id": 3, "price": 120.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET WOOLEN FULL', 1, 'active', 'JACKET WOOLEN FULL', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 3, "price": 90.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET WOOLEN HALF', 1, 'active', 'JACKET WOOLEN HALF', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('JEANS', 1, 'active', 'JEANS', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 70.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA COTTON POLYSTER', 1, 'active', 'KURTA COTTON POLYSTER', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA COTTON', 1, 'active', 'KURTA COTTON', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA FULL EMB. ZARI', 1, 'active', 'KURTA FULL EMB. ZARI', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA PYJAMA', 1, 'active', 'KURTA PYJAMA', 0, '[{"service_id": 1, "price": 220.0}, {"service_id": 2, "price": 160.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA SILK PARTIALLY EMB.', 1, 'active', 'KURTA SILK PARTIALLY EMB.', 0, '[{"service_id": 1, "price": 180.0}, {"service_id": 3, "price": 120.0}]', CURRENT_TIMESTAMP, NULL),
  ('LONGCOAT', 1, 'active', 'LONGCOAT', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('MUFFLER', 1, 'active', 'MUFFLER', 0, '[{"service_id": 1, "price": 100.0}, {"service_id": 2, "price": 70.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('OVERCOAT WOOLEN', 1, 'active', 'OVERCOAT WOOLEN', 0, '[{"service_id": 1, "price": 450.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('PANTS', 1, 'active', 'PANTS', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('PULLOVER', 1, 'active', 'PULLOVER', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('PYJAMA COTTON', 1, 'active', 'PYJAMA COTTON', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 2, "price": 55.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('PYJAMA WOOLEN', 1, 'active', 'PYJAMA WOOLEN', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 65.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('PYJAMA SILK', 1, 'active', 'PYJAMA SILK', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 65.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAFARI SUIT COTTON', 1, 'active', 'SAFARI SUIT COTTON', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 120.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHERWANI', 1, 'active', 'SHERWANI', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHERWANI 2PCS', 1, 'active', 'SHERWANI 2PCS', 0, '[{"service_id": 1, "price": 450.0}, {"service_id": 3, "price": 250.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHERWANI 3PCS', 1, 'active', 'SHERWANI 3PCS', 0, '[{"service_id": 1, "price": 550.0}, {"service_id": 3, "price": 300.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHERWANI ACHKAN FULLY EMBROIDERY', 1, 'active', 'SHERWANI ACHKAN FULLY EMBROIDERY', 0, '[{"service_id": 1, "price": 650.0}, {"service_id": 3, "price": 400.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHERWANI ACHKAN PARTLY EMBROIDERY', 1, 'active', 'SHERWANI ACHKAN PARTLY EMBROIDERY', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 3, "price": 350.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHERWANI ACHKAN REGULAR', 1, 'active', 'SHERWANI ACHKAN REGULAR', 0, '[{"service_id": 1, "price": 450.0}, {"service_id": 3, "price": 350.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHIRT', 1, 'active', 'SHIRT', 0, '[{"service_id": 1, "price": 85.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHIRT COTTON', 1, 'active', 'SHIRT COTTON', 0, '[{"service_id": 1, "price": 85.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHIRT SILK WOOLEN FANCY', 1, 'active', 'SHIRT SILK WOOLEN FANCY', 0, '[{"service_id": 1, "price": 95.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHOES', 1, 'active', 'SHOES', 0, '[{"service_id": 1, "price": 350.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEATHER SHOES', 1, 'active', 'LEATHER SHOES', 0, '[{"service_id": 1, "price": 600.0}]', CURRENT_TIMESTAMP, NULL),
  ('SUEDE SHOES', 1, 'active', 'SUEDE SHOES', 0, '[{"service_id": 1, "price": 500.0}]', CURRENT_TIMESTAMP, NULL),
  ('SUEDE SHOES BOOTS', 1, 'active', 'SUEDE SHOES BOOTS', 0, '[{"service_id": 1, "price": 500.0}]', CURRENT_TIMESTAMP, NULL),
  ('SPORT SHOES', 1, 'active', 'SPORT SHOES', 0, '[{"service_id": 1, "price": 400.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHORTS BRANDED', 1, 'active', 'SHORTS BRANDED', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHORTS REGULAR', 1, 'active', 'SHORTS REGULAR', 0, '[{"service_id": 1, "price": 70.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHORTS SEUDE', 1, 'active', 'SHORTS SEUDE', 0, '[{"service_id": 1, "price": 70.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SOCKS SET OF 2', 1, 'active', 'SOCKS SET OF 2', 0, '[{"service_id": 1, "price": 40.0}, {"service_id": 2, "price": 20.0}, {"service_id": 3, "price": 15.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEAT SHIRT', 1, 'active', 'SWEAT SHIRT', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SUIT 2PCS. GENTS COTTON', 1, 'active', 'SUIT 2PCS. GENTS COTTON', 0, '[{"service_id": 1, "price": 550.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 140.0}]', CURRENT_TIMESTAMP, NULL),
  ('SUIT 2PCS GENTS WOLLEN', 1, 'active', 'SUIT 2PCS GENTS WOLLEN', 0, '[{"service_id": 1, "price": 650.0}, {"service_id": 3, "price": 140.0}]', CURRENT_TIMESTAMP, NULL),
  ('SUIT SET OF 3 GENTS COTTON', 1, 'active', 'SUIT SET OF 3 GENTS COTTON', 0, '[{"service_id": 1, "price": 600.0}, {"service_id": 2, "price": 400.0}, {"service_id": 3, "price": 160.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER CARDIGAN FULL SLEEVES', 1, 'active', 'SWEATER CARDIGAN FULL SLEEVES', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER CARDIGAN SLEEVELESS', 1, 'active', 'SWEATER CARDIGAN SLEEVELESS', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER FS', 1, 'active', 'SWEATER FS', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER HALF', 1, 'active', 'SWEATER HALF', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('T SHIRT REGULAR', 1, 'active', 'T SHIRT REGULAR', 0, '[{"service_id": 1, "price": 85.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('T SHIRT WOOLEN', 1, 'active', 'T SHIRT WOOLEN', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('TRACK SUIT SET OF 2', 1, 'active', 'TRACK SUIT SET OF 2', 0, '[{"service_id": 1, "price": 180.0}, {"service_id": 2, "price": 120.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('TROUSER', 1, 'active', 'TROUSER', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('TROUSER COTTON', 1, 'active', 'TROUSER COTTON', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('TROUSER WOOLEN', 1, 'active', 'TROUSER WOOLEN', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('UNDER GARMENTS REGULAR', 1, 'active', 'UNDER GARMENTS REGULAR', 0, '[{"service_id": 1, "price": 35.0}, {"service_id": 2, "price": 25.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('UNDER WEAR', 1, 'active', 'UNDER WEAR', 0, '[{"service_id": 1, "price": 35.0}, {"service_id": 2, "price": 25.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('VEST', 1, 'active', 'VEST', 0, '[{"service_id": 1, "price": 50.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('SILK SHIRT', 1, 'active', 'SILK SHIRT', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SCARF', 1, 'active', 'SCARF', 0, '[{"service_id": 1, "price": 100.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('VELVET JACKET', 1, 'active', 'VELVET JACKET', 0, '[{"service_id": 1, "price": 450.0}, {"service_id": 3, "price": 90.0}]', CURRENT_TIMESTAMP, NULL),
  ('HAND GLOVES', 1, 'active', 'HAND GLOVES', 0, '[{"service_id": 1, "price": 40.0}, {"service_id": 2, "price": 25.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER SMALL', 1, 'active', 'SWEATER SMALL', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER LONG', 1, 'active', 'SWEATER LONG', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('WAIST COAT BRANDED', 1, 'active', 'WAIST COAT BRANDED', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('PULLOVER (BRANDED)', 1, 'active', 'PULLOVER (BRANDED)', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('PANT (JEAN/CORDUROY)', 1, 'active', 'PANT (JEAN/CORDUROY)', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER BRANDED', 1, 'active', 'SWEATER BRANDED', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHIRT BRANDED', 1, 'active', 'SHIRT BRANDED', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('TSHIRT BRANDED', 1, 'active', 'TSHIRT BRANDED', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('OVERCOAT BRANDED', 1, 'active', 'OVERCOAT BRANDED', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('SUIT BRANDED', 1, 'active', 'SUIT BRANDED', 0, '[{"service_id": 1, "price": 600.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('TSHIRT BRANDED', 1, 'active', 'TSHIRT BRANDED', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET WITH CAP', 1, 'active', 'JACKET WITH CAP', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('RIDER LOWER', 1, 'active', 'RIDER LOWER', 0, '[{"service_id": 1, "price": 800.0}]', CURRENT_TIMESTAMP, NULL),
  ('RIDER JACKET', 1, 'active', 'RIDER JACKET', 0, '[{"service_id": 1, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('TIE', 1, 'active', 'TIE', 0, '[{"service_id": 1, "price": 60.0}, {"service_id": 2, "price": 25.0}, {"service_id": 3, "price": 15.0}]', CURRENT_TIMESTAMP, NULL),
  ('TIE SILK', 1, 'active', 'TIE SILK', 0, '[{"service_id": 1, "price": 75.0}, {"service_id": 3, "price": 15.0}]', CURRENT_TIMESTAMP, NULL),
  ('TURBAN', 1, 'active', 'TURBAN', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEATHER / SUEDE', 1, 'active', 'LEATHER / SUEDE', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('HAND BAG MEN', 1, 'active', 'HAND BAG MEN', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 3, "price": 0.0}]', CURRENT_TIMESTAMP, NULL),
  ('MEN-SUIT (3 PC)', 1, 'active', 'MEN-SUIT (3 PC)', 0, '[{"service_id": 1, "price": 600.0}, {"service_id": 2, "price": 400.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLAZER', 1, 'active', 'BLAZER', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('EMBROIDERED KURTA PYJAMA', 1, 'active', 'EMBROIDERED KURTA PYJAMA', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 2, "price": 250.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('ADVOCATE COAT', 1, 'active', 'ADVOCATE COAT', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('ADVOCATE', 1, 'active', 'ADVOCATE', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('COLLAR & BAND', 1, 'active', 'COLLAR & BAND', 0, '[{"service_id": 1, "price": 100.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('UNDER TURBAN', 1, 'active', 'UNDER TURBAN', 0, '[{"service_id": 1, "price": 100.0}, {"service_id": 2, "price": 70.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('NIGHT SUITS', 1, 'active', 'NIGHT SUITS', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('NEHRU JACKET', 1, 'active', 'NEHRU JACKET', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('BELT FABRIC', 1, 'active', 'BELT FABRIC', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('BELT LEATHER', 1, 'active', 'BELT LEATHER', 0, '[{"service_id": 1, "price": 100.0}, {"service_id": 3, "price": 0.0}]', CURRENT_TIMESTAMP, NULL),
  ('LINEN SHIRT', 1, 'active', 'LINEN SHIRT', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('DESIGNER SUIT SHIRT', 1, 'active', 'DESIGNER SUIT SHIRT', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHERWANI BRIDEGROOM', 1, 'active', 'SHERWANI BRIDEGROOM', 0, '[{"service_id": 1, "price": 1000.0}, {"service_id": 3, "price": 400.0}]', CURRENT_TIMESTAMP, NULL);

-- Insert garments for Womens
INSERT INTO garments_garment (name, category_id, status, description, trash, service_prices, created_at, deleted_at)
VALUES 
  ('BLOUSE CHOLI COTTON', 2, 'active', 'BLOUSE CHOLI COTTON', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLOUSE CHOLI FANCY', 2, 'active', 'BLOUSE CHOLI FANCY', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 90.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLOUSE CHOLI SILK', 2, 'active', 'BLOUSE CHOLI SILK', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 90.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLOUSE SILK', 2, 'active', 'BLOUSE SILK', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 70.0}, {"service_id": 3, "price": 35.0}]', CURRENT_TIMESTAMP, NULL),
  ('BOXER', 2, 'active', 'BOXER', 0, '[{"service_id": 1, "price": 50.0}, {"service_id": 2, "price": 30.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('CAPRI', 2, 'active', 'CAPRI', 0, '[{"service_id": 1, "price": 60.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('CARDIGAN', 2, 'active', 'CARDIGAN', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 90.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT COTTON', 2, 'active', 'COAT COTTON', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT FANCY', 2, 'active', 'COAT FANCY', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 90.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT VEST', 2, 'active', 'COAT VEST', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT WOOLEN', 2, 'active', 'COAT WOOLEN', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 3, "price": 90.0}]', CURRENT_TIMESTAMP, NULL),
  ('DRESS', 2, 'active', 'DRESS', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('DRESS COTTON', 2, 'active', 'DRESS COTTON', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('DRESS SILK', 2, 'active', 'DRESS SILK', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 3, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('DUPATTA COTTON', 2, 'active', 'DUPATTA COTTON', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 2, "price": 55.0}, {"service_id": 3, "price": 35.0}]', CURRENT_TIMESTAMP, NULL),
  ('DUPATTA EMB. ZARI', 2, 'active', 'DUPATTA EMB. ZARI', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 3, "price": 35.0}]', CURRENT_TIMESTAMP, NULL),
  ('DUPATTA SILK', 2, 'active', 'DUPATTA SILK', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 3, "price": 35.0}]', CURRENT_TIMESTAMP, NULL),
  ('DUPATTA SILK CREPE', 2, 'active', 'DUPATTA SILK CREPE', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 3, "price": 35.0}]', CURRENT_TIMESTAMP, NULL),
  ('CHIFFON POLYSTER', 2, 'active', 'CHIFFON POLYSTER', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 3, "price": 35.0}]', CURRENT_TIMESTAMP, NULL),
  ('FROCK(AS PER LINING)', 2, 'active', 'FROCK(AS PER LINING)', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('GOWN WITH BELT', 2, 'active', 'GOWN WITH BELT', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 2, "price": 250.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('GOWN WITHOUT BELT', 2, 'active', 'GOWN WITHOUT BELT', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET COTTON FULL', 2, 'active', 'JACKET COTTON FULL', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 250.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET COTTON HALF', 2, 'active', 'JACKET COTTON HALF', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET FANCY', 2, 'active', 'JACKET FANCY', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 90.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET HALF', 2, 'active', 'JACKET HALF', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 250.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET LEATHER', 2, 'active', 'JACKET LEATHER', 0, '[{"service_id": 1, "price": 400.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET LONG', 2, 'active', 'JACKET LONG', 0, '[{"service_id": 1, "price": 450.0}, {"service_id": 2, "price": 350.0}, {"service_id": 3, "price": 90.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET WOOLEN FULL', 2, 'active', 'JACKET WOOLEN FULL', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 3, "price": 90.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET WOOLEN HALF', 2, 'active', 'JACKET WOOLEN HALF', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('JEANS', 2, 'active', 'JEANS', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 70.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTI COTTON POLYSTER', 2, 'active', 'KURTI COTTON POLYSTER', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTI COTTON', 2, 'active', 'KURTI COTTON', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTAFULL EMB. ZARI', 2, 'active', 'KURTAFULL EMB. ZARI', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTI PYJAMA SILK', 2, 'active', 'KURTI PYJAMA SILK', 0, '[{"service_id": 1, "price": 220.0}, {"service_id": 2, "price": 160.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTI PYJAMA COTTON', 2, 'active', 'KURTI PYJAMA COTTON', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 140.0}, {"service_id": 3, "price": 70.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTI SILK PARTIALLY EMB.', 2, 'active', 'KURTI SILK PARTIALLY EMB.', 0, '[{"service_id": 1, "price": 160.0}, {"service_id": 3, "price": 120.0}]', CURRENT_TIMESTAMP, NULL),
  ('LADIES PURSE', 2, 'active', 'LADIES PURSE', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('LADIES SUIT 3PCS', 2, 'active', 'LADIES SUIT 3PCS', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('LADIES SUIT ETHNIC', 2, 'active', 'LADIES SUIT ETHNIC', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHANGA BRIDAL', 2, 'active', 'LEHANGA BRIDAL', 0, '[{"service_id": 1, "price": 1000.0}, {"service_id": 3, "price": 400.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHENGA', 2, 'active', 'LEHENGA', 0, '[{"service_id": 1, "price": 650.0}, {"service_id": 2, "price": 400.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHENGA PLAIN', 2, 'active', 'LEHENGA PLAIN', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHENGA 2PCS', 2, 'active', 'LEHENGA 2PCS', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 2, "price": 350.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHENGA 3PCS', 2, 'active', 'LEHENGA 3PCS', 0, '[{"service_id": 1, "price": 600.0}, {"service_id": 2, "price": 400.0}, {"service_id": 3, "price": 300.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHENGA FULLY EMB', 2, 'active', 'LEHENGA FULLY EMB', 0, '[{"service_id": 1, "price": 1000.0}, {"service_id": 3, "price": 600.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHENGA PARTIALLY EMB', 2, 'active', 'LEHENGA PARTIALLY EMB', 0, '[{"service_id": 1, "price": 800.0}, {"service_id": 3, "price": 600.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHENGA FULLY EMB ZARI', 2, 'active', 'LEHENGA FULLY EMB ZARI', 0, '[{"service_id": 1, "price": 800.0}, {"service_id": 3, "price": 600.0}]', CURRENT_TIMESTAMP, NULL),
  ('LENEHGA PARTIALLY EMB ZARI', 2, 'active', 'LENEHGA PARTIALLY EMB ZARI', 0, '[{"service_id": 1, "price": 800.0}, {"service_id": 3, "price": 600.0}]', CURRENT_TIMESTAMP, NULL),
  ('LONGCOAT', 2, 'active', 'LONGCOAT', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('MUFFLER', 2, 'active', 'MUFFLER', 0, '[{"service_id": 1, "price": 100.0}, {"service_id": 2, "price": 70.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('NIGHTY', 2, 'active', 'NIGHTY', 0, '[{"service_id": 1, "price": 140.0}, {"service_id": 2, "price": 70.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('PANTS', 2, 'active', 'PANTS', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('PETICOAT', 2, 'active', 'PETICOAT', 0, '[{"service_id": 1, "price": 100.0}, {"service_id": 2, "price": 70.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('PULLOVER', 2, 'active', 'PULLOVER', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('PLAZO SILK', 2, 'active', 'PLAZO SILK', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 3, "price": 70.0}]', CURRENT_TIMESTAMP, NULL),
  ('PLAZO COTTON', 2, 'active', 'PLAZO COTTON', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 70.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('PYJAMA', 2, 'active', 'PYJAMA', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 2, "price": 55.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('PYJAMA COTTON', 2, 'active', 'PYJAMA COTTON', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 2, "price": 55.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('PYJAMA WOOLEN', 2, 'active', 'PYJAMA WOOLEN', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('PYJAMA SILK', 2, 'active', 'PYJAMA SILK', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SALWAR', 2, 'active', 'SALWAR', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SALWAR COTTON', 2, 'active', 'SALWAR COTTON', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 70.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE', 2, 'active', 'SAREE', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 120.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE ROLLING', 2, 'active', 'SAREE ROLLING', 0, '[{"service_id": 1, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE CHARAKH', 2, 'active', 'SAREE CHARAKH', 0, '[{"service_id": 1, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE COTTON', 2, 'active', 'SAREE COTTON', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 120.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE EMB. ZARI OVER ALL', 2, 'active', 'SAREE EMB. ZARI OVER ALL', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE EMB. ZARI PALLU & BORDER', 2, 'active', 'SAREE EMB. ZARI PALLU & BORDER', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE KANCHI', 2, 'active', 'SAREE KANCHI', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 3, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE GOLD WORK', 2, 'active', 'SAREE GOLD WORK', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE DESIGNER', 2, 'active', 'SAREE DESIGNER', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE CHIFFON', 2, 'active', 'SAREE CHIFFON', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 120.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE SILK CREPE CHIFFON', 2, 'active', 'SAREE SILK CREPE CHIFFON', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 120.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE BANSARI', 2, 'active', 'SAREE BANSARI', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 120.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE CREPE SILK', 2, 'active', 'SAREE CREPE SILK', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE GEORGETTE', 2, 'active', 'SAREE GEORGETTE', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE POLYSTER', 2, 'active', 'SAREE POLYSTER', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE SILK WITH WORK', 2, 'active', 'SAREE SILK WITH WORK', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE SILK WITH ZARI', 2, 'active', 'SAREE SILK WITH ZARI', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE WITH WORK', 2, 'active', 'SAREE WITH WORK', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('KERALA SAREE', 2, 'active', 'KERALA SAREE', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('HALF SAREE', 2, 'active', 'HALF SAREE', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 120.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('HALF SAREE SILK', 2, 'active', 'HALF SAREE SILK', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 120.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE - MEDIUM WORK', 2, 'active', 'SAREE - MEDIUM WORK', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE - HEAVY WORK', 2, 'active', 'SAREE - HEAVY WORK', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHAWL', 2, 'active', 'SHAWL', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 100.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHAWL PASHMINA', 2, 'active', 'SHAWL PASHMINA', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 3, "price": 400.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHAWL REGULAR', 2, 'active', 'SHAWL REGULAR', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 100.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHIRT', 2, 'active', 'SHIRT', 0, '[{"service_id": 1, "price": 95.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHIRT COTTON', 2, 'active', 'SHIRT COTTON', 0, '[{"service_id": 1, "price": 95.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHIRT SILK WOOLEN FANCY', 2, 'active', 'SHIRT SILK WOOLEN FANCY', 0, '[{"service_id": 1, "price": 95.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHORTS BRANDED', 2, 'active', 'SHORTS BRANDED', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHORTS REGULAR', 2, 'active', 'SHORTS REGULAR', 0, '[{"service_id": 1, "price": 70.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHORTS SEUDE', 2, 'active', 'SHORTS SEUDE', 0, '[{"service_id": 1, "price": 70.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SKIRT MINI', 2, 'active', 'SKIRT MINI', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SKIRT SMALL', 2, 'active', 'SKIRT SMALL', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SKIRT LONG', 2, 'active', 'SKIRT LONG', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('SKIRT PLAIN COTTON', 2, 'active', 'SKIRT PLAIN COTTON', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SKIRT PLAIN SILK CREPE', 2, 'active', 'SKIRT PLAIN SILK CREPE', 0, '[{"service_id": 1, "price": 65.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('CHIFFON', 2, 'active', 'CHIFFON', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SKIRT PLEATED COTTON', 2, 'active', 'SKIRT PLEATED COTTON', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SKIRT PLEATED SILK', 2, 'active', 'SKIRT PLEATED SILK', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('CREPE CHIFFON', 2, 'active', 'CREPE CHIFFON', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SKIRT TOP', 2, 'active', 'SKIRT TOP', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 100.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SLACKS', 2, 'active', 'SLACKS', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SOCKS SET OF 2', 2, 'active', 'SOCKS SET OF 2', 0, '[{"service_id": 1, "price": 40.0}, {"service_id": 2, "price": 30.0}, {"service_id": 3, "price": 15.0}]', CURRENT_TIMESTAMP, NULL),
  ('STOLE COTTON', 2, 'active', 'STOLE COTTON', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('STOLE MUFFLAR WOOLEN', 2, 'active', 'STOLE MUFFLAR WOOLEN', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 2, "price": 55.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEAT SHIRT', 2, 'active', 'SWEAT SHIRT', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER CARDIGAN FULL SLEEVES', 2, 'active', 'SWEATER CARDIGAN FULL SLEEVES', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER CARDIGAN SLEEVELESS', 2, 'active', 'SWEATER CARDIGAN SLEEVELESS', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER FS', 2, 'active', 'SWEATER FS', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER HS', 2, 'active', 'SWEATER HS', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('T SHIRT REGULAR', 2, 'active', 'T SHIRT REGULAR', 0, '[{"service_id": 1, "price": 85.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('T SHIRT WOOLEN', 2, 'active', 'T SHIRT WOOLEN', 0, '[{"service_id": 1, "price": 85.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('TOP', 2, 'active', 'TOP', 0, '[{"service_id": 1, "price": 85.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('TROUSER', 2, 'active', 'TROUSER', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('TROUSER COTTON', 2, 'active', 'TROUSER COTTON', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('TROUSER WOOLEN', 2, 'active', 'TROUSER WOOLEN', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('UNDER GARMENTS REGULAR', 2, 'active', 'UNDER GARMENTS REGULAR', 0, '[{"service_id": 1, "price": 50.0}, {"service_id": 2, "price": 35.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('VEST', 2, 'active', 'VEST', 0, '[{"service_id": 1, "price": 40.0}, {"service_id": 2, "price": 30.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('SILK SHIRT', 2, 'active', 'SILK SHIRT', 0, '[{"service_id": 1, "price": 110.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('LADIES SUIT 2 PCS ANARKALI', 2, 'active', 'LADIES SUIT 2 PCS ANARKALI', 0, '[{"service_id": 1, "price": 220.0}, {"service_id": 2, "price": 160.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('LADIES SUIT 2 PCS PLAIN', 2, 'active', 'LADIES SUIT 2 PCS PLAIN', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('NIGHT GOWN', 2, 'active', 'NIGHT GOWN', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('GOWN DESIGNER', 2, 'active', 'GOWN DESIGNER', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEGGING', 2, 'active', 'LEGGING', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 2, "price": 55.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SAREE POLISHING', 2, 'active', 'SAREE POLISHING', 0, '[{"service_id": 1, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('BURQA', 2, 'active', 'BURQA', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('BURQA 2 PCS', 2, 'active', 'BURQA 2 PCS', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWIM WEAR', 2, 'active', 'SWIM WEAR', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 100.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('HANDERKERCHIEF', 2, 'active', 'HANDERKERCHIEF', 0, '[{"service_id": 1, "price": 40.0}, {"service_id": 2, "price": 30.0}, {"service_id": 3, "price": 10.0}]', CURRENT_TIMESTAMP, NULL),
  ('SARARA', 2, 'active', 'SARARA', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('SARARA HEAVY', 2, 'active', 'SARARA HEAVY', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('PALAZO/GARARA DESIGNER', 2, 'active', 'PALAZO/GARARA DESIGNER', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 2, "price": 400.0}, {"service_id": 3, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('SMALL PURSE HEAVY', 2, 'active', 'SMALL PURSE HEAVY', 0, '[{"service_id": 1, "price": 300.0}]', CURRENT_TIMESTAMP, NULL);

-- Insert garments for Kids
INSERT INTO garments_garment (name, category_id, status, description, trash, service_prices, created_at, deleted_at)
VALUES 
  ('CAPRI', 3, 'active', 'CAPRI', 0, '[{"service_id": 1, "price": 50.0}, {"service_id": 2, "price": 30.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT/ BLAZER COTTON', 3, 'active', 'COAT/ BLAZER COTTON', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT/ BLAZER FANCY', 3, 'active', 'COAT/ BLAZER FANCY', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 250.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT/ BLAZER VEST', 3, 'active', 'COAT/ BLAZER VEST', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('COAT/ BLAZER WOOLEN', 3, 'active', 'COAT/ BLAZER WOOLEN', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('FROCK(AS PER LINING)', 3, 'active', 'FROCK(AS PER LINING)', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('GOWN WITH BELT', 3, 'active', 'GOWN WITH BELT', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('GOWN WITHOUT BELT', 3, 'active', 'GOWN WITHOUT BELT', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET COTTON FULL', 3, 'active', 'JACKET COTTON FULL', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET COTTON HALF', 3, 'active', 'JACKET COTTON HALF', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET FANCY', 3, 'active', 'JACKET FANCY', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET HALF', 3, 'active', 'JACKET HALF', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET LEATHER', 3, 'active', 'JACKET LEATHER', 0, '[{"service_id": 1, "price": 300.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET LONG', 3, 'active', 'JACKET LONG', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 2, "price": 250.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET WOOLEN FULL', 3, 'active', 'JACKET WOOLEN FULL', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 70.0}]', CURRENT_TIMESTAMP, NULL),
  ('JACKET WOOLEN HALF', 3, 'active', 'JACKET WOOLEN HALF', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('JEANS', 3, 'active', 'JEANS', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA COTTON POLYSTER', 3, 'active', 'KURTA COTTON POLYSTER', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA COTTON', 3, 'active', 'KURTA COTTON', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA FULL EMB. ZARI', 3, 'active', 'KURTA FULL EMB. ZARI', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA PYJAMA', 3, 'active', 'KURTA PYJAMA', 0, '[{"service_id": 1, "price": 220.0}, {"service_id": 2, "price": 160.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA PYJAMA COTTON', 3, 'active', 'KURTA PYJAMA COTTON', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 140.0}, {"service_id": 3, "price": 70.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA SILK PARTIALLY EMB.', 3, 'active', 'KURTA SILK PARTIALLY EMB.', 0, '[{"service_id": 1, "price": 180.0}, {"service_id": 3, "price": 120.0}]', CURRENT_TIMESTAMP, NULL),
  ('KURTA SILK PARTY EMB.', 3, 'active', 'KURTA SILK PARTY EMB.', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('LONGCOAT', 3, 'active', 'LONGCOAT', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('MUFFLER', 3, 'active', 'MUFFLER', 0, '[{"service_id": 1, "price": 60.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('PANTS', 3, 'active', 'PANTS', 0, '[{"service_id": 1, "price": 75.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('PETICOAT', 3, 'active', 'PETICOAT', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('PULLOVER', 3, 'active', 'PULLOVER', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('PLAZO SILK', 3, 'active', 'PLAZO SILK', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('PLAZO COTTON', 3, 'active', 'PLAZO COTTON', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('PYJAMA', 3, 'active', 'PYJAMA', 0, '[{"service_id": 1, "price": 70.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('PYJAMA COTTON', 3, 'active', 'PYJAMA COTTON', 0, '[{"service_id": 1, "price": 70.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('PYJAMA WOOLEN', 3, 'active', 'PYJAMA WOOLEN', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('PYJAMA SILK', 3, 'active', 'PYJAMA SILK', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHERWANI ACHKAN FULLY EMBROIDERY', 3, 'active', 'SHERWANI ACHKAN FULLY EMBROIDERY', 0, '[{"service_id": 1, "price": 450.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHERWANI ACHKAN PARTLY EMBROIDERY', 3, 'active', 'SHERWANI ACHKAN PARTLY EMBROIDERY', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 3, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHERWANI ACHKAN REGULAR', 3, 'active', 'SHERWANI ACHKAN REGULAR', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHIRT', 3, 'active', 'SHIRT', 0, '[{"service_id": 1, "price": 65.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHIRT COTTON', 3, 'active', 'SHIRT COTTON', 0, '[{"service_id": 1, "price": 65.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHIRT SILK WOOLEN FANCY', 3, 'active', 'SHIRT SILK WOOLEN FANCY', 0, '[{"service_id": 1, "price": 65.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHOES', 3, 'active', 'SHOES', 0, '[{"service_id": 1, "price": 350.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHORTS REGULAR', 3, 'active', 'SHORTS REGULAR', 0, '[{"service_id": 1, "price": 50.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('SHORTS SEUDE', 3, 'active', 'SHORTS SEUDE', 0, '[{"service_id": 1, "price": 50.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('SOCKS SET OF 2', 3, 'active', 'SOCKS SET OF 2', 0, '[{"service_id": 1, "price": 30.0}, {"service_id": 2, "price": 25.0}, {"service_id": 3, "price": 10.0}]', CURRENT_TIMESTAMP, NULL),
  ('STOLE COTTON', 3, 'active', 'STOLE COTTON', 0, '[{"service_id": 1, "price": 60.0}, {"service_id": 2, "price": 35.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('STOLE MUFFLAR WOOLEN', 3, 'active', 'STOLE MUFFLAR WOOLEN', 0, '[{"service_id": 1, "price": 70.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEAT SHIRT', 3, 'active', 'SWEAT SHIRT', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 100.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SUIT 2PCS. BOYS COTTON', 3, 'active', 'SUIT 2PCS. BOYS COTTON', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('SUIT 2PCS BOYS WOLLEN', 3, 'active', 'SUIT 2PCS BOYS WOLLEN', 0, '[{"service_id": 1, "price": 450.0}, {"service_id": 3, "price": 120.0}]', CURRENT_TIMESTAMP, NULL),
  ('SUIT 3PCS', 3, 'active', 'SUIT 3PCS', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 140.0}]', CURRENT_TIMESTAMP, NULL),
  ('SUIT SET OF 3 BOYS COTTON', 3, 'active', 'SUIT SET OF 3 BOYS COTTON', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 140.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER CARDIGAN FULL SLEEVES', 3, 'active', 'SWEATER CARDIGAN FULL SLEEVES', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER CARDIGAN SLEEVELESS', 3, 'active', 'SWEATER CARDIGAN SLEEVELESS', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER FS', 3, 'active', 'SWEATER FS', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('SWEATER HS', 3, 'active', 'SWEATER HS', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('T SHIRT REGULAR', 3, 'active', 'T SHIRT REGULAR', 0, '[{"service_id": 1, "price": 65.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('T SHIRT WOOLEN', 3, 'active', 'T SHIRT WOOLEN', 0, '[{"service_id": 1, "price": 85.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('TIE', 3, 'active', 'TIE', 0, '[{"service_id": 1, "price": 40.0}, {"service_id": 2, "price": 20.0}, {"service_id": 3, "price": 10.0}]', CURRENT_TIMESTAMP, NULL),
  ('TOP', 3, 'active', 'TOP', 0, '[{"service_id": 1, "price": 65.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('TROUSER COTTON', 3, 'active', 'TROUSER COTTON', 0, '[{"service_id": 1, "price": 75.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('TROUSER WOOLEN', 3, 'active', 'TROUSER WOOLEN', 0, '[{"service_id": 1, "price": 75.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('UNDER WEAR', 3, 'active', 'UNDER WEAR', 0, '[{"service_id": 1, "price": 40.0}, {"service_id": 2, "price": 30.0}, {"service_id": 3, "price": 15.0}]', CURRENT_TIMESTAMP, NULL),
  ('VEST', 3, 'active', 'VEST', 0, '[{"service_id": 1, "price": 30.0}, {"service_id": 2, "price": 20.0}, {"service_id": 3, "price": 15.0}]', CURRENT_TIMESTAMP, NULL),
  ('SILK SHIRT', 3, 'active', 'SILK SHIRT', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('WAIST COAT', 3, 'active', 'WAIST COAT', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('DENIMS', 3, 'active', 'DENIMS', 0, '[{"service_id": 1, "price": 75.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('GHAGRA HEAVY', 3, 'active', 'GHAGRA HEAVY', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 3, "price": 300.0}]', CURRENT_TIMESTAMP, NULL),
  ('GHAGRA SILK', 3, 'active', 'GHAGRA SILK', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 3, "price": 300.0}]', CURRENT_TIMESTAMP, NULL),
  ('GHAGRA ORNAMNTAL', 3, 'active', 'GHAGRA ORNAMNTAL', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 3, "price": 300.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHENGA 2PCS', 3, 'active', 'LEHENGA 2PCS', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHENGA 3PCS', 3, 'active', 'LEHENGA 3PCS', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 2, "price": 400.0}, {"service_id": 3, "price": 300.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHENGA FULLY EMB', 3, 'active', 'LEHENGA FULLY EMB', 0, '[{"service_id": 1, "price": 600.0}, {"service_id": 3, "price": 400.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEHENGA PARTIALLY EMB ZARI', 3, 'active', 'LEHENGA PARTIALLY EMB ZARI', 0, '[{"service_id": 1, "price": 500.0}, {"service_id": 3, "price": 300.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLOUSE WORK', 3, 'active', 'BLOUSE WORK', 0, '[{"service_id": 1, "price": 100.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLOUSE CHOLI COTTON', 3, 'active', 'BLOUSE CHOLI COTTON', 0, '[{"service_id": 1, "price": 100.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLOUSE CHOLI FANCY', 3, 'active', 'BLOUSE CHOLI FANCY', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLOUSE CHOLI SILK', 3, 'active', 'BLOUSE CHOLI SILK', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 40.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLOUSE SILK', 3, 'active', 'BLOUSE SILK', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 70.0}, {"service_id": 3, "price": 35.0}]', CURRENT_TIMESTAMP, NULL),
  ('TOP DESIGNER', 3, 'active', 'TOP DESIGNER', 0, '[{"service_id": 1, "price": 65.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('TOP HEAVY', 3, 'active', 'TOP HEAVY', 0, '[{"service_id": 1, "price": 65.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('GOWN DESIGNER', 3, 'active', 'GOWN DESIGNER', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('GOWN', 3, 'active', 'GOWN', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEGGING', 3, 'active', 'LEGGING', 0, '[{"service_id": 1, "price": 70.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('DUPATTA HEAVY', 3, 'active', 'DUPATTA HEAVY', 0, '[{"service_id": 1, "price": 70.0}, {"service_id": 2, "price": 45.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL);

-- Insert garments for Household
INSERT INTO garments_garment (name, category_id, status, description, trash, service_prices, created_at, deleted_at)
VALUES 
  ('BAG BIG', 4, 'active', 'BAG BIG', 0, '[{"service_id": 1, "price": 600.0}, {"service_id": 2, "price": 300.0}]', CURRENT_TIMESTAMP, NULL),
  ('BAG SMALL', 4, 'active', 'BAG SMALL', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('BATH MAT', 4, 'active', 'BATH MAT', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('BATH TOWEL', 4, 'active', 'BATH TOWEL', 0, '[{"service_id": 1, "price": 95.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('BED COVER', 4, 'active', 'BED COVER', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLANKET DOUBLE 250/KG', 4, 'active', 'BLANKET DOUBLE 250/KG', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLANKET SINGLE 250/KG', 4, 'active', 'BLANKET SINGLE 250/KG', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 60.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLINDS COTTON', 4, 'active', 'BLINDS COTTON', 0, '[{"service_id": 1, "price": 400.0}, {"service_id": 2, "price": 300.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('BLINDS SILK', 4, 'active', 'BLINDS SILK', 0, '[{"service_id": 1, "price": 600.0}, {"service_id": 2, "price": 400.0}, {"service_id": 3, "price": 120.0}]', CURRENT_TIMESTAMP, NULL),
  ('CARPET', 4, 'active', 'CARPET', 0, '[{"service_id": 1, "price": 300.0}]', CURRENT_TIMESTAMP, NULL),
  ('COMFORTER', 4, 'active', 'COMFORTER', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('COUCH LARGE THREE SEATER', 4, 'active', 'COUCH LARGE THREE SEATER', 0, '[{"service_id": 1, "price": 4001200.0}]', CURRENT_TIMESTAMP, NULL),
  ('COUCH MEDIUM DOUBLE SEATER', 4, 'active', 'COUCH MEDIUM DOUBLE SEATER', 0, '[{"service_id": 1, "price": 4001200.0}]', CURRENT_TIMESTAMP, NULL),
  ('CURTAIN', 4, 'active', 'CURTAIN', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('CUSHION COVER WORK', 4, 'active', 'CUSHION COVER WORK', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 100.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('CUSION COVER', 4, 'active', 'CUSION COVER', 0, '[{"service_id": 1, "price": 90.0}, {"service_id": 2, "price": 60.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('CUSION COVER COTTON', 4, 'active', 'CUSION COVER COTTON', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('CUSION COVER LARGE', 4, 'active', 'CUSION COVER LARGE', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 100.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('CUSION COVER MEDIUM', 4, 'active', 'CUSION COVER MEDIUM', 0, '[{"service_id": 1, "price": 120.0}, {"service_id": 2, "price": 80.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('CUSION COVER SILK', 4, 'active', 'CUSION COVER SILK', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('CUSION COVER SMALL', 4, 'active', 'CUSION COVER SMALL', 0, '[{"service_id": 1, "price": 60.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('CUSION LARGE', 4, 'active', 'CUSION LARGE', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('CUSION MEDIUM', 4, 'active', 'CUSION MEDIUM', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('CUSION SMALL', 4, 'active', 'CUSION SMALL', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('FOOT MAT LARGE', 4, 'active', 'FOOT MAT LARGE', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 150.0}]', CURRENT_TIMESTAMP, NULL),
  ('FOOT MAT MEDIUM', 4, 'active', 'FOOT MAT MEDIUM', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('FOOT MAT SMALL', 4, 'active', 'FOOT MAT SMALL', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('HAND TOWEL', 4, 'active', 'HAND TOWEL', 0, '[{"service_id": 1, "price": 60.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 25.0}]', CURRENT_TIMESTAMP, NULL),
  ('HANKEY', 4, 'active', 'HANKEY', 0, '[{"service_id": 1, "price": 40.0}, {"service_id": 2, "price": 30.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('MATRESS SI NGLE BED', 4, 'active', 'MATRESS SI NGLE BED', 0, '[{"service_id": 1, "price": 1200.0}]', CURRENT_TIMESTAMP, NULL),
  ('MATTRESS DOUBLE BED', 4, 'active', 'MATTRESS DOUBLE BED', 0, '[{"service_id": 1, "price": 2000.0}]', CURRENT_TIMESTAMP, NULL),
  ('QUILT DOUDLE', 4, 'active', 'QUILT DOUDLE', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('STUFF TOY BIG', 4, 'active', 'STUFF TOY BIG', 0, '[{"service_id": 1, "price": 600.0}, {"service_id": 2, "price": 400.0}]', CURRENT_TIMESTAMP, NULL),
  ('STUF F TOY SMALL', 4, 'active', 'STUF F TOY SMALL', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('TABLE CLOTH LARGE', 4, 'active', 'TABLE CLOTH LARGE', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('TABLE CLOTH SMALL', 4, 'active', 'TABLE CLOTH SMALL', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 100.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('TABLE MAT', 4, 'active', 'TABLE MAT', 0, '[{"service_id": 1, "price": 150.0}, {"service_id": 2, "price": 100.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('BEDSHEET(DOUBLE)', 4, 'active', 'BEDSHEET(DOUBLE)', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('SCHOOL BAG', 4, 'active', 'SCHOOL BAG', 0, '[{"service_id": 1, "price": 350.0}, {"service_id": 2, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('FACE TOWEL', 4, 'active', 'FACE TOWEL', 0, '[{"service_id": 1, "price": 60.0}, {"service_id": 2, "price": 40.0}, {"service_id": 3, "price": 20.0}]', CURRENT_TIMESTAMP, NULL),
  ('PILLOW COVER', 4, 'active', 'PILLOW COVER', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('PILLOW', 4, 'active', 'PILLOW', 0, '[{"service_id": 1, "price": 200.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('BED SPREAD QUILT', 4, 'active', 'BED SPREAD QUILT', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 200.0}]', CURRENT_TIMESTAMP, NULL),
  ('CAR SEAT COVER', 4, 'active', 'CAR SEAT COVER', 0, '[{"service_id": 1, "price": 600.0}, {"service_id": 2, "price": 400.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('CHAIR', 4, 'active', 'CHAIR', 0, '[{"service_id": 1, "price": 400800.0}]', CURRENT_TIMESTAMP, NULL),
  ('CURTAIN BELTS', 4, 'active', 'CURTAIN BELTS', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('SOFA COVER', 4, 'active', 'SOFA COVER', 0, '[{"service_id": 1, "price": 300.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 100.0}]', CURRENT_TIMESTAMP, NULL),
  ('BED SHEET DOUBLE', 4, 'active', 'BED SHEET DOUBLE', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('BATH ROBE', 4, 'active', 'BATH ROBE', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 150.0}, {"service_id": 3, "price": 50.0}]', CURRENT_TIMESTAMP, NULL),
  ('DUVET COVER', 4, 'active', 'DUVET COVER', 0, '[{"service_id": 1, "price": 250.0}, {"service_id": 2, "price": 200.0}, {"service_id": 3, "price": 80.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEATHER/SUEDE BAG L', 4, 'active', 'LEATHER/SUEDE BAG L', 0, '[{"service_id": 1, "price": 800.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEATHER/SUEDE BAG M', 4, 'active', 'LEATHER/SUEDE BAG M', 0, '[{"service_id": 1, "price": 600.0}]', CURRENT_TIMESTAMP, NULL),
  ('LEATHER/SUEDE BAG S', 4, 'active', 'LEATHER/SUEDE BAG S', 0, '[{"service_id": 1, "price": 400.0}]', CURRENT_TIMESTAMP, NULL),
  ('APRON', 4, 'active', 'APRON', 0, '[{"service_id": 1, "price": 80.0}, {"service_id": 2, "price": 50.0}, {"service_id": 3, "price": 30.0}]', CURRENT_TIMESTAMP, NULL),
  ('HOME CLEANING', 4, 'active', 'HOME CLEANING', 0, '[{"service_id": 1, "price": 9.0}]', CURRENT_TIMESTAMP, NULL);

