from django.test import TestCase
from .models import Garment, GarmentServicePrice
from services.models import Service

class GarmentModelTest(TestCase):
    def test_create_garment(self):
        g = Garment.objects.create(name='Shirt', status='active')
        self.assertEqual(str(g), 'Shirt')

    def test_garment_service_price(self):
        g = Garment.objects.create(name='Shirt', status='active')
        s = Service.objects.create(service_name='Washing', status='active')
        gsp = GarmentServicePrice.objects.create(garment=g, service=s, price=50)
        self.assertEqual(str(gsp), 'Shirt - Washing : 50')
