
from django.db import models

class Banner(models.Model):
	STATUS_CHOICES = [
		('active', 'Active'),
		('inactive', 'Inactive'),
	]
	title = models.CharField(max_length=255)
	description = models.TextField()
	image = models.ImageField(upload_to='banners/')
	status = models.CharField(max_length=10, choices=STATUS_CHOICES, default='active')
	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)

	def __str__(self):
		return self.title
