from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import BackToBase

@receiver(post_save, sender=BackToBase)
def update_booking_status(sender, instance, created, **kwargs):
    if created:
        booking = instance.booking
        if booking.booking_status != 'back_to_base':
            booking.booking_status = 'back_to_base'
            booking.save()
