from django.db import models
from django.conf import settings

class BackToBase(models.Model):
    booking = models.ForeignKey('bookings.Booking', on_delete=models.CASCADE, related_name='back_to_base_entries')
    rider = models.ForeignKey('riders.Rider', on_delete=models.SET_NULL, null=True, blank=True, related_name='back_to_base_entries')
    customer = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.CASCADE, related_name='back_to_base_entries')
    
    poc_name = models.CharField(max_length=255, null=True, blank=True)
    poc_mobile = models.CharField(max_length=32, null=True, blank=True)
    reason = models.TextField(null=True, blank=True)
    
    is_resolved = models.BooleanField(default=False)
    resolved_at = models.DateTimeField(null=True, blank=True)

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    class Meta:
        verbose_name = "Back to Base Entry"
        verbose_name_plural = "Back to Base Entries"
        ordering = ['-created_at']

    def __str__(self):
        return f"BackToBase - {self.booking.booking_id}"

