from django.urls import path
from .views import (
    ServiceManagementView, ServiceCreateView, ServiceDetailViewWeb, ServiceEditView, ServiceDeleteView
)

urlpatterns = [
    path('service-management/', ServiceManagementView.as_view(), name='service-management'),
    path('service-management/create', ServiceCreateView.as_view(), name='service-create'),
    path('service-management/<int:pk>/', ServiceDetailViewWeb.as_view(), name='service-view'),
    path('service-management/<int:pk>/edit/', ServiceEditView.as_view(), name='service-edit'),
    path('service-management/<int:pk>/delete/', ServiceDeleteView.as_view(), name='service-delete'),
]
