from django.urls import path
from .views import (
    RiderManagementView, RiderCreateView, RiderDetailViewWeb, RiderEditView, RiderDeleteView
)

urlpatterns = [
    path('rider-management/', RiderManagementView.as_view(), name='rider-management'),
    path('rider-management/create', RiderCreateView.as_view(), name='rider-create'),
    path('rider-management/<int:pk>/', RiderDetailViewWeb.as_view(), name='rider-view'),
    path('rider-management/<int:pk>/edit/', RiderEditView.as_view(), name='rider-edit'),
    path('rider-management/<int:pk>/delete/', RiderDeleteView.as_view(), name='rider-delete'),
]
