from django.db import models
from django.conf import settings


class Rider(models.Model):
	# Link to the project's User model (one-to-one). Optional to allow
	# creating Rider records independently for admin workflows.
	user = models.OneToOneField(
		settings.AUTH_USER_MODEL,
		null=True,
		blank=True,
		on_delete=models.CASCADE,
		related_name='rider_profile',
	)
	STATUS_CHOICES = [
		("active", "Active"),
		("inactive", "Inactive"),
	]

	full_name = models.CharField(max_length=255)
	display_name = models.CharField(max_length=255, null=True, blank=True)
	dob = models.DateField(null=True, blank=True)
	mobile_number = models.CharField(max_length=20)
	email = models.EmailField(null=True, blank=True)
	# Authentication/credentials are stored on the project's User model.
	# Do not store passwords here; use the linked `user` account instead.

	profile_pic = models.ImageField(upload_to='riders/profile/', null=True, blank=True)

	# Documents
	aadhar_front = models.ImageField(upload_to='riders/documents/aadhar/', null=True, blank=True)
	aadhar_back = models.ImageField(upload_to='riders/documents/aadhar/', null=True, blank=True)
	pan_card_image = models.ImageField(upload_to='riders/documents/pancard/', null=True, blank=True)
	driving_license_front = models.ImageField(upload_to='riders/documents/driving_license/', null=True, blank=True)
	driving_license_back = models.ImageField(upload_to='riders/documents/driving_license/', null=True, blank=True)

	status = models.CharField(max_length=10, choices=STATUS_CHOICES, default='active')
	trash = models.BooleanField(default=False)

	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)

	def __str__(self):
		return self.display_name or self.full_name

