from django.contrib import admin
from .models import Product


@admin.register(Product)
class ProductAdmin(admin.ModelAdmin):
    list_display = ('id', 'product_name', 'category', 'price', 'unit', 'trash', 'created_at', 'deleted_at')
    search_fields = ('product_name', 'description')
    list_filter = ('trash',)

