from django.contrib import admin
from django.urls import path, include

from django.contrib import admin
from django.urls import path, include
from django.contrib.auth import views as auth_views
from rest_framework import permissions
from drf_yasg.views import get_schema_view
from drf_yasg import openapi
from users.views import DashboardView
from django.conf import settings
from django.conf.urls.static import static

schema_view = get_schema_view(
    openapi.Info(
        title="Ironers API",
        default_version='v1',
        description="API documentation for Ironers project",
    ),
    public=True,
    permission_classes=(permissions.AllowAny,),
)

urlpatterns = [
    path('admin/', admin.site.urls),
    # Project-level API aggregator (versioned)
    path('api/v1/', include('ironers.urls_api')),
    path('dashboard/', include('users.urls_web')),
    path('dashboard/', include('banners.urls_web')),
    path('dashboard/', include('global_settings.urls_web')),
    path('dashboard/', include('services.urls_web')),
    path('dashboard/', include('products.web_urls')),
    path('dashboard/', include('garments.urls_web')),
    path('dashboard/', include('category.urls_web')),
    path('dashboard/', include('riders.urls_web')),
    path('dashboard/', include('bookings.urls_web')),
    path('dashboard/', include('back_to_base.urls_web')),
    path('dashboard/', include('brands.urls_web')),
    path('dashboard/', include('materials.urls_web')),
    path('dashboard/', include('service_requests.urls_web')),

    # Web login/logout
    path('login/', auth_views.LoginView.as_view(template_name='pages/login.html'), name='login'),
    path('logout/', auth_views.LogoutView.as_view(next_page='login'), name='logout'),
    path('dashboard/', DashboardView.as_view(), name='dashboard'),

    path('swagger/', schema_view.with_ui('swagger', cache_timeout=0), name='schema-swagger-ui'),
    path('redoc/', schema_view.with_ui('redoc', cache_timeout=0), name='schema-redoc'),
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
