from rest_framework.views import APIView
from rest_framework import permissions
from .models import GlobalSetting
from common.response_helper import ResponseHelper


class GlobalSettingsTimeSlotsAPIView(APIView):
    """Public endpoint that returns the list of time slots from GlobalSetting."""
    permission_classes = [permissions.AllowAny]

    def get(self, request):
        settings_obj, _ = GlobalSetting.objects.get_or_create(pk=1)
        return ResponseHelper.success(data={'time_slots': settings_obj.time_slots}, message='Global time slots')
