from rest_framework.response import Response

class ResponseHelper:
    @staticmethod
    def success(data=None, message='', title='Success', status=200):
        return Response({
            'title': title,
            'status': True,
            'code': status,
            'message': message,
            'data': data
        }, status=status)

    @staticmethod
    def error(message='Something went wrong', errors=None, title='Error', status=400):
        return Response({
            'title': title,
            'status': False,
            'code': status,
            'message': message,
            'errors': errors if errors is not None else []
        }, status=status)

    @staticmethod
    def validation_error(errors, message='Validation error', title='Validation Failed'):
        return Response({
            'title': title,
            'status': False,
            'code': 422,
            'message': message,
            'errors': errors
        }, status=422)

    @staticmethod
    def server_error(message='Internal server error', errors=None, title='Server Error'):
        return Response({
            'title': title,
            'status': False,
            'code': 500,
            'message': message,
            'errors': errors if errors is not None else []
        }, status=500)
