from django.urls import path
from .views import (
    CategoryManagementView, CategoryCreateView, CategoryDetailViewWeb, CategoryEditView, CategoryDeleteView
)

urlpatterns = [
    path('category-management/', CategoryManagementView.as_view(), name='category-management'),
    path('category-management/create', CategoryCreateView.as_view(), name='category-create'),
    path('category-management/<int:pk>/', CategoryDetailViewWeb.as_view(), name='category-view'),
    path('category-management/<int:pk>/edit/', CategoryEditView.as_view(), name='category-edit'),
    path('category-management/<int:pk>/delete/', CategoryDeleteView.as_view(), name='category-delete'),
]
