from django.db import models
from django.conf import settings

class Cart(models.Model):
    user = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.CASCADE, related_name='carts')
    quick_schedule = models.BooleanField(default=False)
    
    PICKUP_TYPE_CHOICES = [
        ('normal', 'Normal'),
        ('express', 'Express'),
    ]
    pickup_type = models.CharField(max_length=16, choices=PICKUP_TYPE_CHOICES, default='normal')

    schedule_pickup_date = models.DateField(null=True, blank=True)
    schedule_pickup_time = models.CharField(max_length=64, null=True, blank=True)

    contact_name = models.CharField(max_length=255, blank=True)
    contact_mobile = models.CharField(max_length=32, blank=True)
    pickup_instructions = models.TextField(null=True, blank=True)

    # Snapshot of pickup address
    pickup_address = models.JSONField(default=dict, blank=True)

    # Geo location
    geo_location = models.JSONField(default=dict, blank=True)

    # Order details stored as JSON
    order_details = models.JSONField(default=dict, blank=True)
    premium_details = models.JSONField(default=dict, blank=True)
    luxury_details = models.JSONField(default=dict, blank=True)

    total_quantity = models.IntegerField(default=0)
    total_final_price = models.DecimalField(max_digits=12, decimal_places=2, default=0)
    currency_code = models.CharField(max_length=8, default='INR')

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    class Meta:
        ordering = ['-updated_at']

    def __str__(self):
        return f"Cart {self.pk} - {self.user}"
