from django import forms
from .models import Brand

class BrandForm(forms.ModelForm):
    class Meta:
        model = Brand
        fields = ['brand_name', 'brand_description', 'brand_image', 'status']
        widgets = {
            'brand_name': forms.TextInput(attrs={'class': 'form-control'}),
            'brand_description': forms.Textarea(attrs={'class': 'form-control', 'rows': 3}),
            'brand_image': forms.FileInput(attrs={'class': 'form-control'}),
            'status': forms.Select(attrs={'class': 'form-select'}),
        }
