from django.contrib import admin
from .models import Booking


@admin.register(Booking)
class BookingAdmin(admin.ModelAdmin):
    list_display = ('id', 'booking_id', 'user', 'booking_status', 'pickup_type', 'schedule_pickup_date', 'total_final_price', 'created_at')
    list_filter = ('booking_status', 'schedule_pickup_date')
    search_fields = ('user__username', 'contact_mobile')

