# Generated by Django 5.2.6 on 2025-12-09 09:54

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('products', '0001_initial'),
        ('services', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Offer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=50, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
                ('slug', models.SlugField(blank=True, null=True, unique=True)),
                ('offer_type', models.CharField(choices=[('percentage', 'Percentage'), ('fixed_amount', 'Fixed Amount'), ('buy_x_get_y', 'Buy X Get Y')], default='percentage', max_length=20)),
                ('discount_percentage', models.DecimalField(blank=True, decimal_places=2, max_digits=5, null=True)),
                ('discount_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('max_discount_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('buy_quantity', models.IntegerField(blank=True, null=True)),
                ('get_quantity', models.IntegerField(blank=True, null=True)),
                ('get_discount_percent', models.DecimalField(blank=True, decimal_places=2, max_digits=5, null=True)),
                ('apply_to_all', models.BooleanField(default=False)),
                ('minimum_purchase_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('maximum_purchase_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('minimum_quantity', models.IntegerField(blank=True, null=True)),
                ('usage_limit_total', models.IntegerField(blank=True, null=True)),
                ('usage_limit_per_user', models.IntegerField(blank=True, null=True)),
                ('used_count', models.IntegerField(default=0)),
                ('is_active', models.BooleanField(default=True)),
                ('auto_apply', models.BooleanField(default=False)),
                ('exclude_sale_items', models.BooleanField(default=False)),
                ('first_order_only', models.BooleanField(default=False)),
                ('priority', models.IntegerField(default=0)),
                ('start_date', models.DateTimeField(blank=True, null=True)),
                ('end_date', models.DateTimeField(blank=True, null=True)),
                ('brands', models.JSONField(blank=True, default=list, help_text='List of Brand Names')),
                ('categories', models.JSONField(blank=True, default=list, help_text='List of Category Names')),
                ('products', models.JSONField(blank=True, default=list, help_text='List of Product Names')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('gift_product', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='gift_offers', to='products.product')),
                ('services', models.ManyToManyField(blank=True, related_name='offers', to='services.service')),
            ],
        ),
    ]
