from django import forms
from .models import Offer
from brands.models import Brand
from category.models import Category
from products.models import Product
from garments.models import Garment
from services.models import Service

class OfferForm(forms.ModelForm):
    brands = forms.MultipleChoiceField(
        choices=[],
        required=False,
        widget=forms.SelectMultiple(attrs={'class': 'form-control select2-multiple', 'multiple': 'multiple'})
    )
    categories = forms.MultipleChoiceField(
        choices=[],
        required=False,
        widget=forms.SelectMultiple(attrs={'class': 'form-control select2-multiple', 'multiple': 'multiple'})
    )
    products = forms.MultipleChoiceField(
        choices=[],
        required=False,
        widget=forms.SelectMultiple(attrs={'class': 'form-control select2-multiple', 'multiple': 'multiple'})
    )
    services = forms.ModelMultipleChoiceField(
        queryset=Service.objects.all(),
        required=False,
        widget=forms.SelectMultiple(attrs={'class': 'form-control select2-multiple', 'multiple': 'multiple'})
    )

    class Meta:
        model = Offer
        exclude = ['slug', 'apply_to_all']
        widgets = {
            'code': forms.TextInput(attrs={'class': 'form-control'}),
            'name': forms.TextInput(attrs={'class': 'form-control'}),
            'description': forms.Textarea(attrs={'class': 'form-control', 'rows': 3}),
            'offer_type': forms.Select(attrs={'class': 'form-select', 'id': 'id_offer_type'}),
            'discount_percentage': forms.NumberInput(attrs={'class': 'form-control'}),
            'discount_amount': forms.NumberInput(attrs={'class': 'form-control'}),
            'max_discount_amount': forms.NumberInput(attrs={'class': 'form-control'}),
            'buy_quantity': forms.NumberInput(attrs={'class': 'form-control'}),
            'get_quantity': forms.NumberInput(attrs={'class': 'form-control'}),
            'get_discount_percent': forms.NumberInput(attrs={'class': 'form-control'}),
            'gift_product': forms.TextInput(attrs={'class': 'form-control', 'placeholder': 'Enter Product ID'}),
            'minimum_purchase_amount': forms.NumberInput(attrs={'class': 'form-control'}),
            'maximum_purchase_amount': forms.NumberInput(attrs={'class': 'form-control'}),
            'minimum_quantity': forms.NumberInput(attrs={'class': 'form-control'}),
            'usage_limit_total': forms.NumberInput(attrs={'class': 'form-control'}),
            'usage_limit_per_user': forms.NumberInput(attrs={'class': 'form-control'}),
            'priority': forms.NumberInput(attrs={'class': 'form-control'}),
            'start_date': forms.DateTimeInput(attrs={'class': 'form-control', 'type': 'datetime-local'}),
            'end_date': forms.DateTimeInput(attrs={'class': 'form-control', 'type': 'datetime-local'}),
            'is_active': forms.CheckboxInput(attrs={'class': 'form-check-input'}),
            'auto_apply': forms.CheckboxInput(attrs={'class': 'form-check-input'}),
            'exclude_sale_items': forms.CheckboxInput(attrs={'class': 'form-check-input'}),
            'first_order_only': forms.CheckboxInput(attrs={'class': 'form-check-input'}),
        }

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        
        # Populate choices for JSONFields
        self.fields['brands'].choices = [(b.brand_name, b.brand_name) for b in Brand.objects.filter(trash=False)]
        self.fields['categories'].choices = [(c.name, c.name) for c in Category.objects.filter(trash=False)]
        self.fields['products'].choices = [(g.name, g.name) for g in Garment.objects.filter(trash=False)]
        
        # Set initial values for JSONFields if instance exists
        if self.instance.pk:
            self.initial['brands'] = self.instance.brands
            self.initial['categories'] = self.instance.categories
            self.initial['products'] = self.instance.products


    def clean(self):
        cleaned_data = super().clean()
        # Ensure JSONFields are saved as lists
        cleaned_data['brands'] = cleaned_data.get('brands', [])
        cleaned_data['categories'] = cleaned_data.get('categories', [])
        cleaned_data['products'] = cleaned_data.get('products', [])
        return cleaned_data
