from rest_framework import viewsets
from .models import Discount
from .serializers import DiscountSerializer
from common.response_helper import ResponseHelper

class DiscountViewSet(viewsets.ModelViewSet):
    queryset = Discount.objects.filter(trash=False)
    serializer_class = DiscountSerializer

    def list(self, request, *args, **kwargs):
        queryset = self.filter_queryset(self.get_queryset())
        serializer = self.get_serializer(queryset, many=True)
        return ResponseHelper.success(data=serializer.data, message="Discounts fetched successfully")

    def retrieve(self, request, *args, **kwargs):
        instance = self.get_object()
        serializer = self.get_serializer(instance)
        return ResponseHelper.success(data=serializer.data, message="Discount fetched successfully")

    def create(self, request, *args, **kwargs):
        serializer = self.get_serializer(data=request.data)
        if serializer.is_valid():
            self.perform_create(serializer)
            return ResponseHelper.success(data=serializer.data, message="Discount created successfully", status=201)
        return ResponseHelper.validation_error(errors=serializer.errors)

    def update(self, request, *args, **kwargs):
        partial = kwargs.pop('partial', False)
        instance = self.get_object()
        serializer = self.get_serializer(instance, data=request.data, partial=partial)
        if serializer.is_valid():
            self.perform_update(serializer)
            return ResponseHelper.success(data=serializer.data, message="Discount updated successfully")
        return ResponseHelper.validation_error(errors=serializer.errors)

    def destroy(self, request, *args, **kwargs):
        instance = self.get_object()
        instance.delete()
        return ResponseHelper.success(message="Discount deleted successfully")
