from django.shortcuts import render, redirect, get_object_or_404
from django.contrib import messages
from .models import Discount
from .forms import DiscountForm

def discount_list(request):
    discounts = Discount.objects.filter(trash=False).order_by('-created_at')
    return render(request, 'discounts/discount_list.html', {'discounts': discounts})

def discount_create(request):
    if request.method == 'POST':
        form = DiscountForm(request.POST)
        if form.is_valid():
            form.save()
            messages.success(request, 'Discount created successfully.')
            return redirect('discount_list')
    else:
        form = DiscountForm()
    return render(request, 'discounts/discount_form.html', {'form': form, 'title': 'Create Discount'})

def discount_update(request, pk):
    discount = get_object_or_404(Discount, pk=pk)
    if request.method == 'POST':
        form = DiscountForm(request.POST, instance=discount)
        if form.is_valid():
            form.save()
            messages.success(request, 'Discount updated successfully.')
            return redirect('discount_list')
    else:
        form = DiscountForm(instance=discount)
    return render(request, 'discounts/discount_form.html', {'form': form, 'title': 'Update Discount'})

def discount_delete(request, pk):
    discount = get_object_or_404(Discount, pk=pk)
    if request.method == 'POST':
        discount.delete()
        messages.success(request, 'Discount deleted successfully.')
        return redirect('discount_list')
    return render(request, 'discounts/discount_confirm_delete.html', {'discount': discount})

def discount_detail(request, pk):
    discount = get_object_or_404(Discount, pk=pk)
    return render(request, 'discounts/discount_detail.html', {'discount': discount})
