from django.db import models

class Discount(models.Model):
    DISCOUNT_TYPE_CHOICES = [
        ('percentage', 'Percentage'),
        ('amount', 'Fixed Amount'),
    ]

    code = models.CharField(max_length=50, unique=True)
    description = models.TextField(blank=True, null=True)
    is_active = models.BooleanField(default=True)
    valid_from = models.DateTimeField(null=True, blank=True)
    valid_until = models.DateTimeField(null=True, blank=True)
    
    discount_type = models.CharField(max_length=20, choices=DISCOUNT_TYPE_CHOICES, default='percentage')
    discount_percentage = models.DecimalField(max_digits=5, decimal_places=2, null=True, blank=True, help_text="Enter percentage (e.g. 10 for 10%)")
    discount_amount = models.DecimalField(max_digits=10, decimal_places=2, null=True, blank=True)
    max_discount_amount = models.DecimalField(max_digits=10, decimal_places=2, null=True, blank=True, help_text="Maximum discount amount for percentage based discounts")
    
    apply_to_all_brands = models.JSONField(default=list, blank=True, help_text="List of Brand Names")
    apply_to_all_products = models.JSONField(default=list, blank=True, help_text="List of Product Names")
    apply_to_all_services = models.JSONField(default=list, blank=True, help_text="List of Service Names")
    
    minimum_amount = models.DecimalField(max_digits=10, decimal_places=2, default=0)
    maximum_uses_total = models.IntegerField(null=True, blank=True, help_text="Total number of times this coupon can be used")
    maximum_uses_per_user = models.IntegerField(null=True, blank=True, help_text="Limit per user")
    single_use = models.BooleanField(default=False)

    trash = models.BooleanField(default=False)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return self.code
