from django import forms
from .models import Discount
from brands.models import Brand
from garments.models import Garment
from services.models import Service

class DiscountForm(forms.ModelForm):
    apply_to_all_brands = forms.MultipleChoiceField(
        required=False,
        widget=forms.SelectMultiple(attrs={'class': 'form-control select2-multiple', 'data-placeholder': 'Select Brands'})
    )
    apply_to_all_products = forms.MultipleChoiceField(
        required=False,
        widget=forms.SelectMultiple(attrs={'class': 'form-control select2-multiple', 'data-placeholder': 'Select Products'})
    )
    apply_to_all_services = forms.MultipleChoiceField(
        required=False,
        widget=forms.SelectMultiple(attrs={'class': 'form-control select2-multiple', 'data-placeholder': 'Select Services'})
    )

    class Meta:
        model = Discount
        fields = '__all__'
        exclude = ['trash', 'created_at', 'updated_at']
        widgets = {
            'valid_from': forms.DateTimeInput(attrs={'type': 'datetime-local', 'class': 'form-control'}),
            'valid_until': forms.DateTimeInput(attrs={'type': 'datetime-local', 'class': 'form-control'}),
            'code': forms.TextInput(attrs={'class': 'form-control'}),
            'description': forms.Textarea(attrs={'class': 'form-control', 'rows': 3}),
            'discount_type': forms.Select(attrs={'class': 'form-control'}),
            'discount_percentage': forms.NumberInput(attrs={'class': 'form-control'}),
            'discount_amount': forms.NumberInput(attrs={'class': 'form-control'}),
            'max_discount_amount': forms.NumberInput(attrs={'class': 'form-control'}),
            'minimum_amount': forms.NumberInput(attrs={'class': 'form-control'}),
            'maximum_uses_total': forms.NumberInput(attrs={'class': 'form-control'}),
            'maximum_uses_per_user': forms.NumberInput(attrs={'class': 'form-control'}),
            'is_active': forms.CheckboxInput(attrs={'class': 'form-check-input'}),
            'single_use': forms.CheckboxInput(attrs={'class': 'form-check-input'}),
        }

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.fields['apply_to_all_brands'].choices = [(b.brand_name, b.brand_name) for b in Brand.objects.filter(trash=False)]
        self.fields['apply_to_all_products'].choices = [(g.name, g.name) for g in Garment.objects.filter(trash=False)]
        self.fields['apply_to_all_services'].choices = [(s.service_name, s.service_name) for s in Service.objects.all()] # Service doesn't have trash field based on previous read

