from rest_framework import generics, permissions
from .models import Brand
from .serializers import BrandSerializer

class BrandListAPIView(generics.ListAPIView):
    queryset = Brand.objects.filter(status='active', trash=False).order_by('-created_at')
    serializer_class = BrandSerializer
    permission_classes = [permissions.AllowAny]
    pagination_class = None # Or use a paginator if needed
